/***************************************************************/
//
//
//		DirectX	[ model.cpp ]
//
//											Author	kazuki tanaka
//											Date	2016 10/26
/*---------------------------------------------------------------
Update : 2016/10/26
			model.cpp̍쐬

/*---------------------------------------------------------------
	CN[ht@C
---------------------------------------------------------------*/

#include "main.h"
#include "model.h"

#include "input.h"

#include "d_log.h"

//#include <Windows.h>
//#include <stdio.h>
//#include <d3dx9.h>

//#pragma comment (lib,"d3d9.lib")
//#pragma comment (lib,"d3dx9.lib")
//#pragma comment (lib,"dxguid.lib")


/*---------------------------------------------------------------
	}N`
---------------------------------------------------------------*/

#define SAFE_RELEASE(p) { if (p) { (p)->Release(); (p)=NULL; } }
#define RADIAN( theta ) ((( theta ) * D3DX_PI ) / 180 )	// WApւ̕ϊ

// AtBϊ
#define AFFINE_TRANSFORM_X( radiusX, radiusY, theta ) \
(( radiusX ) * cosf( RADIAN( theta )) - ( radiusY ) * sinf( RADIAN( theta )))

#define AFFINE_TRANSFORM_Y( radiusX, radiusY, theta ) \
(( radiusX ) * sinf( RADIAN( theta )) + ( radiusY ) * cosf( RADIAN( theta )))


/*---------------------------------------------------------------
	萔`
---------------------------------------------------------------*/

/*---------------------------------------------------------------
	vg^Cv錾
---------------------------------------------------------------*/

/*---------------------------------------------------------------
	O[oϐ
---------------------------------------------------------------*/

LPD3DXMESH g_pMeshModel;						// bVC^[tFCX|C^
LPD3DXBUFFER g_pBufMatModel;					// }eA

DWORD g_nNumMatModel;							// }eA

D3DXMATRIX localMtx;							// [JW̍Ws

D3DXVECTOR3 g_posModel;							// fW
D3DXVECTOR3 g_rotModel;							// f]
D3DXVECTOR3 g_sclModel;							// fg嗦

float scale = 1.0f;								// gkl

LPDIRECT3DTEXTURE9* pTextureModel = nullptr;	// eNX`-C^[tF-Xp

static bool modelAct = true;


// MODEL̏
void InitModel( void )
{

	HRESULT hr;
	char str[256]={}; 

	// foCX̎󂯎
	LPDIRECT3DDEVICE9 pDevice = GetDevice( );

	// [JW̏
	g_posModel = D3DXVECTOR3( 0, 0, 0 );
	g_rotModel = D3DXVECTOR3( 0, 0, 0 );
	g_sclModel = D3DXVECTOR3( 1.0, 1.0, 1.0 );

	// t@Cl[̎擾
	const char XFILE_NAME[] = "data\\MODEL\\tank000.x";

	// Xt@C̃[h	
	hr = D3DXLoadMeshFromX( 
		XFILE_NAME,
		D3DXMESH_MANAGED,
		pDevice,
		NULL,
		&g_pBufMatModel,
		NULL,
		&g_nNumMatModel,
		&g_pMeshModel );
	if( FAILED( hr )){

		#ifdef _DEBUG
		sprintf( str, " %s \n ERROR CODE : 0x%x", XFILE_NAME, hr );
		MessageBox( NULL, str, " XFILE LOAD ERROR!! ", 0 || MB_ICONWARNING );
		#endif	// _DEBUG

	}else{ 
	// TEXTURE LOAD
	
		// }eÃ|C^ƂăAhX擾
		D3DXMATERIAL* pMat =( D3DXMATERIAL*)g_pBufMatModel -> GetBufferPointer( );

		// eNX`obt@
		pTextureModel = new LPDIRECT3DTEXTURE9[ (int)g_nNumMatModel ];

		for( int index = 0; index < (int)g_nNumMatModel; index++ ){

			// eNX`̓ǂݍ 
			hr = D3DXCreateTextureFromFile( pDevice, pMat[ index ].pTextureFilename, &pTextureModel[index] );
			if( FAILED( hr )) {
				#ifdef _DEBUG
				#endif	// _DEBUG]

				// NULLleNX`}eA
				pMat[ index ].pTextureFilename = NULL;
			}
		}

	}	// -> END TEXTURE LOAD PROCESS




}

// MODEL̏I
void UninitModel( void )
{

	// eNX`obt@̏
	SAFE_DELETE_ARRAY( pTextureModel )

	// }eẢ
	SAFE_RELEASE( g_pBufMatModel )

	// {̏
	//SAFE_DELETE( )

}

// MODEL̍XV
void UpdateModel( void )
{


	// foCX̎󂯎
	LPDIRECT3DDEVICE9 pDevice = GetDevice( );

	// f
	if( modelAct ){

		// ]
		if( GetKeyboardPress( DIK_M )){
			scale += 0.01f;
		}
		if( GetKeyboardPress( DIK_N )){
			scale -= 0.01f;
		}

		g_sclModel = D3DXVECTOR3( scale, scale, scale );

		// ]
		if( GetKeyboardPress( DIK_UP )){
			g_rotModel.z ++;
		}
		if( GetKeyboardPress( DIK_DOWN )){
			g_rotModel.z --;
		}
		if( GetKeyboardPress( DIK_LEFT )){
			g_rotModel.y --;
		}
		if( GetKeyboardPress( DIK_RIGHT )){
			g_rotModel.y ++;
		}

		// sړ
		if( GetKeyboardPress( DIK_S )){
			g_posModel.z ++;
		}
		if( GetKeyboardPress( DIK_W )){
			g_posModel.z --;
		}
		if( GetKeyboardPress( DIK_D )){
			g_posModel.x --;
		}
		if( GetKeyboardPress( DIK_A )){
			g_posModel.x ++;
		}
	}

	// ON/OFFtO؂ւ
	if( GetKeyboardTrigger( DIK_F2 ) ){
	
		if( modelAct ){
			modelAct = false;
		}
		else if( !modelAct ){
			modelAct = true;
		}
	}


	D3DXMATRIX mtxScale;
	D3DXMATRIX mtxRotation;
	D3DXMATRIX mtxTrans;

	// fW̕ϊ
	D3DXMatrixScaling( &mtxScale, g_sclModel.x, g_sclModel.y, g_sclModel.z );
	D3DXMatrixRotationYawPitchRoll( &mtxRotation, D3DXToRadian( g_rotModel.y ), D3DXToRadian( g_rotModel.x ), D3DXToRadian( g_rotModel.z ) );
	D3DXMatrixTranslation( &mtxTrans, g_posModel.x, g_posModel.y, g_posModel.z );


	// Pʍsւ̏( sPʍsɂ )
	D3DXMatrixIdentity( &localMtx );

	// s̍
 	localMtx = localMtx * mtxScale;
	localMtx = localMtx * mtxRotation;
	localMtx = localMtx * mtxTrans;

	// foCXɃ[hϊsݒ
	//pDevice ->SetTransform( D3DTS_WORLD, &localMtx );



}

// MODEL̕`
void DrawModel( void )
{


	// -- f` --

	// foCX̎󂯎
	LPDIRECT3DDEVICE9 pDevice = GetDevice( );

	// ݃foCXɐݒ肳Ă}eA̎擾
	D3DMATERIAL9 matDef;
	pDevice -> GetMaterial( &matDef );

	// }eÃ|C^ƂăAhX擾
	D3DXMATERIAL* pMat =( D3DXMATERIAL*)g_pBufMatModel -> GetBufferPointer( );

	// foCXɃ[hϊsݒ
	pDevice ->SetTransform( D3DTS_WORLD, &localMtx );


	for( int index = 0; index < (int)g_nNumMatModel; index++ ){

		// foCXɃ}eAݒ
		pDevice -> SetMaterial( &pMat[ index ].MatD3D );

		// eNX`ݒ
		if( !pTextureModel[index] ){
			pDevice -> SetTexture( 0, pTextureModel[index] );
		}else{
			pDevice -> SetTexture( 0, NULL );		
		}

		// MODEL`
		g_pMeshModel->DrawSubset( index );
	}

	// ̃}eAݒ
	pDevice -> SetMaterial( &matDef );

	/*
	D3DXMATRIX mtxDefault;

	// Pʍsւ̏( sPʍsɂ )
	D3DXMatrixIdentity( &mtxDefault );

	// foCXɃ[hϊsݒ
	pDevice ->SetTransform( D3DTS_WORLD, &mtxDefault );

	for( int index = 0; index < (int)g_nNumMatModel; index++ ){

		// foCXɃ}eAݒ
		pDevice -> SetMaterial( &pMat[ index ].MatD3D );

		// eNX`ݒ
		//pDevice -> SetTexture( 0, &pMat[ index ].pTextureFilename );
		pDevice -> SetTexture( 0, g_pTextureModel );
		//pDevice -> SetTexture( 0, NULL );
		pDevice -> SetTexture( 0, g_pTextureModel2 );

		// MODEL`
		g_pMeshModel->DrawSubset( index );
	}

	pDevice -> SetMaterial( &matDef );
	*/


}

// [JWs̎擾
D3DXMATRIX GetMatrixModel( void )
{

	return localMtx;

}





